require "selenium-webdriver"
require "rspec"
require "./spec/spec_helper"
require_relative "../../pages/_config"
require "./pages/provider_login"
require "./pages/search"
include RSpec::Expectations


describe "Patient Search: PV-1439" do

  before(:all) do
    @driver = Selenium::WebDriver.for :firefox
    @base_url = $acp_url
    @wrapper_url = $acp_url + "/" + $acp_app
    @accept_next_alert = true
    @wait = Selenium::WebDriver::Wait.new(:timeout => 10)
    @driver.manage.timeouts.implicit_wait = 3
    @verification_errors = []

    @login = ProviderLogin.new @driver
    @login.loginAsCprs1234()
            
    @driver.get(@wrapper_url)
    @search = Search.new(@driver)
  end
  
  after(:all) do
    @driver.quit
    @verification_errors.should == []
  end
  
  before(:each) do
    @driver.get(@wrapper_url)
  end
  
    describe "Patient Search by Ward: PV-123" do
      
      it 'should display the heading of Ward Search: PV-114' do
        @search.openSearchMenu()
        @search.selectWardSearch()
        @wait.until{ @driver.find_element(:css, '.ui-title').text !='' }
        expect(@search.getSearchHeader()).to eq('Ward Search')
      end
  
      it 'should display an alphabetically-sorted list of wards: PV-112' do
        @search.searchByWard('7a') #1E SICU in prod mode
  
        list = @search.getDisplayedList('#location-list li:not(.ui-screen-hidden) h3')
        
        previousWard = list[0]
        for i in (0...list.size)
          nextWard = list[i]
          expect(previousWard <= nextWard).to be_true
          previousWard = nextWard
        end
      end
      
      it 'should display an alphabetically-sorted list of patients within a selected ward: PV-123' do
        @search.searchByWard('7a')
        @search.selectWardAtRow(4)
        @wait.until{ @driver.find_element(:css, '#patient-list li h3') }
        list = @search.getDisplayedList('#patient-list li h3')
        previousPatient = list[0].downcase()
        for i in (0...list.size)
          if(list[i].downcase() != "")
            nextPatient = list[i].downcase()
          end
          expect(previousPatient <= nextPatient).to be_true
          previousPatient = nextPatient
        end
  
      end
  
      it 'should allow filtering of patients within a ward: PV-273' do
        @search.searchByWard('7a')
        @search.selectWardAtRow(4)
        
        startingResultLength = @search.getSearchResultsLength()
        @search.filterSearchResults("eight")
        sleep(5) #wait for results to be refreshed
        expect(startingResultLength).to be > @search.getSearchResultsLength()
        @search.clearFilterSearchResultsField()
        sleep(5) #wait for results to be refreshed
        expect(@search.getSearchResultsLength()).to eq(startingResultLength)
        @search
      end
      
      it 'should persist search criteria: PV-381' do
        @search.searchByWard('7A')
        @search.selectWardAtRow(4)
        #Navigate away from search and return
        @search.selectClinicSearch()
        sleep(1)
        @search.selectWardSearch()
        sleep(1)
        
        expect(@search.getSearchCriteria()).to eq('7A GEN MED')
      end
   
    end #Close Ward describe block 
   
  
end  